/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.feature;

import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_304;
import net.minecraft.class_310;

public class KeybindFeature
implements MarkdownFeature {
    @Override
    public String name() {
        return "keybindings";
    }

    @Override
    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    @Override
    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<keybind;")) {
                return false;
            }
            String keybindKey = nibbler.consumeUntil('>');
            if (keybindKey == null) {
                return false;
            }
            Optional<class_304> binding = Arrays.stream(class_310.method_1551().field_1690.field_1839).filter($ -> $.method_1431().equals(keybindKey)).findAny();
            if (binding.isEmpty()) {
                return false;
            }
            tokens.add(new KeybindToken(keybindKey, binding.get()));
            return true;
        }, '<');
    }

    @Override
    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, keybindToken, tokens) -> new KeybindNode(keybindToken.binding), (token, tokens) -> {
            KeybindToken keybind;
            return token instanceof KeybindToken ? (keybind = (KeybindToken)token) : null;
        });
    }

    private static class KeybindToken
    extends Lexer.Token {
        public final class_304 binding;

        public KeybindToken(String content, class_304 binding) {
            super(content);
            this.binding = binding;
        }
    }

    private static class KeybindNode
    extends Parser.Node {
        private final class_304 binding;

        public KeybindNode(class_304 binding) {
            this.binding = binding;
        }

        @Override
        public void visitStart(MarkdownCompiler<?> compiler) {
            compiler.visitStyle(style -> style.method_10977(class_124.field_1065).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"text.lavender.keybind_tooltip", (Object[])new Object[]{class_2561.method_43471((String)this.binding.method_1423()), class_2561.method_43471((String)this.binding.method_1431())}))));
            compiler.visitText(class_1074.method_4662((String)this.binding.method_1428(), (Object[])new Object[0]));
        }

        @Override
        protected void visitEnd(MarkdownCompiler<?> compiler) {
            compiler.visitStyleEnd();
        }
    }
}

